﻿<?php include "ob/db.php"; ?>
<?php include "ob/kontrol.php" ?>
<?php include "ob/ayarlar.php"; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo $ayar_cek['firma_adi'] ?></title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="assets/css/sweetalert.css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="global_assets/js/main/jquery.min.js"></script>
	<script src="global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="global_assets/js/plugins/ui/slinky.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	
	<script src="global_assets/js/plugins/forms/inputs/inputmask.js"></script>
	<script src="global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="global_assets/js/plugins/ui/sticky.min.js"></script>
	<script src="global_assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="assets/js/app.js"></script>
    <script src="global_assets/js/demo_pages/navbar_multiple_sticky.js"></script>
    <script src="global_assets/js/demo_pages/form_select2.js"></script>
    <script src="global_assets/js/plugins/forms/styling/uniform.min.js"></script>
    <script src="assets/js/sweetalert.min.js"></script>
	<!-- /theme JS files -->
</head>
<body>
	<?php include "lib/navbar.php" ?>
	<?php include "lib/menu.php" ?>
	<div class="page-content pt-10">
		<div class="content-wrapper">
			<div class="content">
				<div class="card">
					<div class="card-header bg-light header-elements-inline">
						<h5 class="card-title"><i class="icon-box f24"></i> Stok Bilgileri</h5>
						<div class="header-elements">
							<div class="list-icons">
		                		<a class="list-icons-item" data-action="collapse"></a>
		                		<a class="list-icons-item" data-action="reload"></a>
		                		<a class="list-icons-item" data-action="remove"></a>
		                	</div>
	                	</div>
					</div>
					<form action="" method="POST" id="add" onsubmit="return false;">
						<div class="card-body gri">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Stok No <small class="text-danger">(*)</small></label>
												<input type="text" name="stok_no" class="form-control degerBuyuk">
											</div>
											<div class="col-md-4">
												<label>Stok Adı <small class="text-danger">(*)</small></label>
												<input type="text" name="stok_adi" class="form-control degerBuyuk">
											</div>
											<div class="col-md-4">
												<label>Üretici</label>
												<input type="text" name="stok_uretici" class="form-control degerBuyuk">
											</div>
											<div class="col-md-2">
												<label>Üretici No</label>
												<input type="text" name="stok_uretici_no" class="form-control degerBuyuk">
											</div>
										</div>
										<div class="cizgileme"></div>
									</div>

									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Stok Türü <small class="text-danger">(*)</small></label>
												<select name="stok_turu" id="tur" class="form-control select-search">
													<option value="">Seçim Yap...</option>
													<?php
	                                                $tur = $db->prepare("SELECT * FROM ob_stok_turu");
	                                                $tur->execute(array());
	                                                $turne = $tur->fetchAll(PDO::FETCH_ASSOC);
	                                                foreach ($turne as $turlist) { ?>
	                                                    <option value="<?php echo $turlist['stok_turu_id']; ?>"><?php echo $turlist['stok_turu_ad']; ?></option>
	                                                <?php } ?>
												</select>
											</div>
											<div class="col-md-2">
												<label>marka</label>
												<select name="stok_marka" id="marka" class="form-control select-search">
													<option value="">Önce Stok Türü Seçin...</option>
												</select>
											</div>
											<div class="col-md-2">
												<label>Model</label>
												<select name="stok_model" id="model" class="form-control select-search">
													<option value="">Önce Marka Seçin...</option>
												</select>
											</div>
											<div class="col-md-2">
												<label>Stok Tipi <small class="text-danger">(*)</small></label>
												<select name="stok_tipi" class="form-control select-search">
													<option value="">Seçim yap...</option>
													<?php
	                                                $stoktipi = $db->prepare("SELECT * FROM ob_stok_tipi");
	                                                $stoktipi->execute(array());
	                                                $stoktipine = $stoktipi->fetchAll(PDO::FETCH_ASSOC);
	                                                foreach ($stoktipine as $stoktiplist) { ?>
	                                                    <option value="<?php echo $stoktiplist['id']; ?>"><?php echo $stoktiplist['ad']; ?></option>
	                                                <?php } ?>
												</select>
											</div>
											<div class="col-md-4">
												<label>Barkod <small class="text-danger">(*)</small></label>
												<input type="text" name="stok_barkod" class="form-control degerBuyuk">
											</div>
											
										</div>
										<div class="cizgileme"></div>
									</div>
									
									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Stok Birimi</label>
												<select name="stok_birim" class="form-control select-search">
													<?php
	                                                $stokbirim = $db->prepare("SELECT * FROM ob_stok_birim");
	                                                $stokbirim->execute(array());
	                                                $stokbirimne = $stokbirim->fetchAll(PDO::FETCH_ASSOC);
	                                                foreach ($stokbirimne as $stokbirimlist) { ?>
	                                                    <option value="<?php echo $stokbirimlist['id']; ?>"><?php echo $stokbirimlist['ad']; ?></option>
	                                                <?php } ?>
												</select>
											</div>
											<div class="col-md-2">
												<label>KDVSİ</label>
												<select name="stok_kdv" id="stok_kdv" class="form-control select-search">
													<option value="">KDV Seçin...</option>
													<option value="18">%18</option>
													<option value="8">%8</option>
													<option value="1">%1</option>
													<option value="0">%0</option>
												</select>
											</div>
											<div class="col-md-2">
												<label>Liste Fiyatı <small class="text-danger">(KDV HARİÇ)</small></label>
												<input type="text" name="stok_liste_fiyat_kdvsiz" id="kdvharic" class="form-control">
											</div>
											<div class="col-md-2">
												<label>Liste Fiyatı <small class="text-danger">(KDV DAHİL)</small></label>
												<input type="hidden" name="test" id="sonuc" class="form-control" readonly="">
												<input type="text" name="stok_liste_fiyat_kdvli" id="sonuc2" class="form-control" readonly="">
											</div>
											<div class="col-md-2">
												<label>Mevcut Stok</label>
												<input type="text" name="stok_kalan" class="form-control" value="0" readonly="">
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-footer">
							<div class="text-right">
								<button type="submit" onclick="stokekle();" class="btn btn-primary">Bilgileri Kaydet</button>
								<button type="reset" class="btn btn-secondary">Bilgileri Temizle</button>
							</div>
						</div>
					</form>
				</div>
			</div>
			<div class="bosluk"></div>
		</div>
	</div>
	<?php include "ob/footer.php" ?>
	<script type="text/javascript">
		$('.degerBuyuk').keyup(function(){
		    this.value=this.value.toUpperCase();
		});
	</script>
	<script type="text/javascript">
		$(document).ready(function(){
	    $('#tur').on('change', function(){
	        var turID = $(this).val();
	        if(turID){
	            $.ajax({
	                type:'POST',
	                url:'markamodel.php',
	                data:'stok_turu_id='+turID,
	                success:function(html){
	                    $('#marka').html(html);
	                    $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	                }
	            }); 
	        }else{
	            $('#marka').html('<option value="">Önce Stok Türü Seçin...</option>');
	            $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	        }
	    });
	    
	    $('#marka').on('change', function(){
	        var MarkaID = $(this).val();
	        if(MarkaID){
	            $.ajax({
	                type:'POST',
	                url:'markamodel.php',
	                data:'stok_marka_id='+MarkaID,
	                success:function(html){
	                    $('#model').html(html);
	                }
	            }); 
	        }else{
	            $('#model').html('<option value="">Önce Marka Seçin...</option>'); 
	        }
	    });
	});
	</script>
	<script type="text/javascript">
		function toplam(){
			var stok_kdv = document.getElementById("stok_kdv").value;
			var kdvharic = document.getElementById("kdvharic").value;
			var sonuc = document.getElementById("sonuc").value;
			if (stok_kdv == "" || kdvharic == "" || sonuc == "") {
				document.getElementById("sonuc").value="0"
			} else {
				document.getElementById("sonuc").value= parseFloat(stok_kdv) * parseFloat(kdvharic) / 100;
				document.getElementById("sonuc2").value= parseFloat(sonuc) + parseFloat(kdvharic);
			}
		}
		setInterval("toplam()",100);
	</script>
	
	<script type="text/javascript">
		function stokekle(){
			var deger = $("#add").serialize();
			$.ajax({
				type	: "POST",
				data 	: deger,
				url 	: "stokadd.php",
				success	: function(sonuc){
					if ($.trim(sonuc) == "stokno") {
						sweetAlert('DİKKAT!', 'Stok No Yazmadınız...','error');
					} else if ($.trim(sonuc) == "stokadi") {
						sweetAlert('DİKKAT!', 'Stok Adı Yazmadınız...','error');
					} else if ($.trim(sonuc) == "stokturu") {
						sweetAlert('DİKKAT!', 'Stok Türü Seçmediniz....','error');
					} else if ($.trim(sonuc) == "stokmarka") {
						sweetAlert('DİKKAT!', 'Marka Seçmediniz....','error');
					} else if ($.trim(sonuc) == "stokmodel") {
						sweetAlert('DİKKAT!', 'Model Seçmediniz....','error');
					} else if ($.trim(sonuc) == "stoktipi") {
						sweetAlert('DİKKAT!', 'Stok Tipi Seçmediniz....','error');
					} else if ($.trim(sonuc) == "stokbarkod") {
						sweetAlert('DİKKAT!', 'Barcode Yazmadınız...','error');
					} else if ($.trim(sonuc) == "stokbirim") {
						sweetAlert('DİKKAT!', 'Stok Birimi Seçmediniz....','error');
					} else if ($.trim(sonuc) == "stokkdv") {
						sweetAlert('DİKKAT!', 'Kdv Seçmediniz....','error');
					} else if ($.trim(sonuc) == "mukstokno") {
						sweetAlert('DİKKAT!', 'Bu Stok No Başka Üründe Kullanılmaktadır...','warning');
					} else if ($.trim(sonuc) == "mukbarkod") {
						sweetAlert('DİKKAT!', 'Bu Barkod Başka Üründe Kullanılmaktadır...','warning');
					} else if ($.trim(sonuc) == "hata") {
						sweetAlert('Hata', 'hatalı','error');
					} else if ($.trim(sonuc) == "ok") {
						swal({
						  title: "Başarılı!",
						  text: "Stok Oluşturuldu...",
						  type: "success",
						  confirmButtonText: "Tamam"
						},
						function(isConfirm){
						  if (isConfirm) {
						    window.location.href = "StokListe";
						  }
						});
					}
				}
			});
		} 
	</script>
</body>
</html>