﻿<?php include "ob/db.php"; ?>
<?php include "ob/kontrol.php" ?>
<?php include "ob/ayarlar.php"; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo $ayar_cek['firma_adi'] ?></title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="assets/css/sweetalert.css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="global_assets/js/main/jquery.min.js"></script>
	<script src="global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="global_assets/js/plugins/ui/slinky.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	
	<script src="global_assets/js/plugins/forms/inputs/inputmask.js"></script>
	<script src="global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="global_assets/js/plugins/ui/sticky.min.js"></script>
	<script src="global_assets/js/plugins/forms/selects/select2.min.js"></script>
	<script src="assets/js/app.js"></script>
    <script src="global_assets/js/demo_pages/navbar_multiple_sticky.js"></script>
    <script src="global_assets/js/demo_pages/form_select2.js"></script>
    <script src="global_assets/js/plugins/forms/styling/uniform.min.js"></script>
    <script src="assets/js/sweetalert.min.js"></script>
	<!-- /theme JS files -->
</head>
<body>
	<?php include "lib/navbar.php" ?>
	<?php include "lib/menu.php" ?>
	<div class="page-content pt-10">
		<div class="content-wrapper">
			<div class="content">
				<div class="card">
					<div class="card-header bg-light header-elements-inline">
						<h5 class="card-title"><i class="icon-users"></i> Personel Bilgileri</h5>
						<div class="header-elements">
							<div class="list-icons">
		                		<a class="list-icons-item" data-action="collapse"></a>
		                		<a class="list-icons-item" data-action="reload"></a>
		                		<a class="list-icons-item" data-action="remove"></a>
		                	</div>
	                	</div>
					</div>
					<form action="" method="POST" id="add" onsubmit="return false;">
						<div class="card-body gri">
							<div class="row">
								<div class="col-md-12">
									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Ad <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_ad" class="form-control degerBuyuk">
											</div>
											<div class="col-md-2">
												<label>Soyad <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_soyad" class="form-control degerBuyuk">
											</div>
											<div class="col-md-2">
												<label>TC Kimlik No <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_tc" class="form-control" data-mask="99999999999">
											</div>
											<div class="col-md-2">
												<label>Ev Telefon</label>
												<input type="text" name="personel_telefon" class="form-control" data-mask="(999) 999-9999">
											</div>
											<div class="col-md-2">
												<label>Gsm <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_gsm" class="form-control" data-mask="(999) 999-9999">
											</div>
											<div class="col-md-2">
												<label>E-Posta</label>
												<input type="email" name="personel_mail" class="form-control">
											</div>
										</div>
										<div class="cizgileme"></div>
									</div>

									<div class="form-group">
										<div class="row">
											<div class="col-md-12">
												<label>Ev Adresi <small class="text-danger">(*)</small></label>
												<textarea name="personel_adres" class="form-control degerBuyuk"></textarea>
											</div>
										</div>
										<div class="cizgileme"></div>
									</div>

									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Doğum Tarihi <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_dtarih" class="form-control" data-mask="99-99-9999">
											</div>
											<div class="col-md-2">
												<label>Giriş Tarihi <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_gtarih" class="form-control" data-mask="99-99-9999">
											</div>
											<div class="col-md-2">
												<label>Çıkış Tarihi <small class="text-danger">(*)</small></label>
												<input type="text" name="personel_ctarih" class="form-control" data-mask="99-99-9999">
											</div>
											<div class="col-md-2">
												<label>Görevi</label>
												<select name="personel_gorev" class="form-control select-search">
													<option value="" selected="">Seçim Yapın...</option>
													<?php
	                                                $gorev = $db->prepare("SELECT * FROM ob_personel_gorev");
	                                                $gorev->execute(array());
	                                                $gorevne = $gorev->fetchAll(PDO::FETCH_ASSOC);
	                                                foreach ($gorevne as $gorevlist) { ?>
	                                                    <option value="<?php echo $gorevlist['id']; ?>"><?php echo $gorevlist['gorev']; ?></option>
	                                                <?php } ?>
												</select>
											</div>
											<div class="col-md-2">
												<label>Görev Durumu</label>
												<select name="personel_gorev_durum" class="form-control select-search">
													<option value="" selected="">Seçim Yapın...</option>
													<option value="1">ÇALIŞIYOR</option>
													<option value="2">ÇALIŞMIYOR</option>
												</select>
											</div>
											<div class="col-md-2">
												<label>Çalışma Şekli</label>
												<select name="personel_calisma_sekil" class="form-control select-search">
													<option value="" selected="">Seçim Yapın...</option>
													<option value="1">AYLIKÇI</option>
													<option value="2">HAFTALIKÇI</option>
												</select>
											</div>
										</div>
										<div class="cizgileme"></div>
									</div>
									
									<div class="form-group">
										<div class="row">
											<div class="col-md-2">
												<label>Maaş</label>
												<input type="text" name="personel_maas" class="form-control">
											</div>
											<div class="col-md-2">
												<label>IBAN</label>
												<input type="text" name="personel_iban" class="form-control" data-mask="TR99-9999-9999-9999-9999-9999-99">
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="card-footer">
							<div class="text-right">
								<button type="submit" onclick="personelekle();" class="btn btn-primary">Bilgileri Kaydet</button>
							</div>
						</div>
					</form>
				</div>
			</div>
			<div class="bosluk"></div>
		</div>
	</div>
	<?php include "ob/footer.php" ?>
	<script type="text/javascript">
		$('.degerBuyuk').keyup(function(){
		    this.value=this.value.toUpperCase();
		});
	</script>
	<script type="text/javascript">
		function personelekle(){
			var deger = $("#add").serialize();
			$.ajax({
				type	: "POST",
				data 	: deger,
				url 	: "personeladd.php",
				success	: function(sonuc){
					if ($.trim(sonuc) == "personelad") {
						sweetAlert('DİKKAT!', 'Personel Adı Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personelsoyad") {
						sweetAlert('DİKKAT!', 'Personel Soyadı Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personeltc") {
						sweetAlert('DİKKAT!', 'TC Kimlik No Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personelgsm") {
						sweetAlert('DİKKAT!', 'Gsm No Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personeladres") {
						sweetAlert('DİKKAT', 'Açık Adresi Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personeldtarih") {
						sweetAlert('DİKKAT', 'Doğum Tarihi Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personelgorev") {
						sweetAlert('DİKKAT', 'Görev Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "personelgorevdurum") {
						sweetAlert('DİKKAT', 'Personel Görev Durumu Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "personelcalismasekil") {
						sweetAlert('DİKKAT', 'Çalışma Şekli Seçmediniz...','warning');
					} else if ($.trim(sonuc) == "personelmaas") {
						sweetAlert('DİKKAT', 'Maaş Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "personeliban") {
						sweetAlert('DİKKAT', 'IBAN Yazmadınız...','warning');
					} else if ($.trim(sonuc) == "hata") {
						sweetAlert('HATA', 'Hata Oluştu...','error');
					} else if ($.trim(sonuc) == "muk") {
						sweetAlert('DİKKAT', 'Bu TC Kimlik No kullanılmaktadır...','error');
					} else if ($.trim(sonuc) == "ok") {
						swal({
						  title: "Başarılı!",
						  text: "Personel Oluşturuldu...",
						  type: "success",
						  confirmButtonText: "Tamam"
						},
						function(isConfirm){
						  if (isConfirm) {
						    window.location.href = "PersonelListe";
						  }
						});
					}
				}
			});
		} 
	</script>
</body>
</html>