﻿<?php include "ob/db.php"; ?>
<?php include "ob/kontrol.php" ?>
<?php include "ob/ayarlar.php"; ?>
<!DOCTYPE html>
<html lang="tr">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title><?php echo $ayar_cek['firma_adi'] ?></title>

	<!-- Global stylesheets -->
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet" type="text/css">
	<link href="global_assets/css/icons/icomoon/styles.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/bootstrap_limitless.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/layout.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/components.min.css" rel="stylesheet" type="text/css">
	<link href="assets/css/colors.min.css" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	<!-- Core JS files -->
	<script src="global_assets/js/main/jquery.min.js"></script>
	<script src="global_assets/js/main/bootstrap.bundle.min.js"></script>
	<script src="global_assets/js/plugins/loaders/blockui.min.js"></script>
	<script src="global_assets/js/plugins/ui/slinky.min.js"></script>
	<script src="global_assets/js/plugins/tables/datatables/datatables.min.js"></script>
	<!-- /core JS files -->

	<!-- Theme JS files -->
	<script src="global_assets/js/plugins/forms/styling/switchery.min.js"></script>
	<script src="global_assets/js/plugins/ui/sticky.min.js"></script>
	<script src="global_assets/js/plugins/tables/datatables/extensions/jszip/jszip.min.js"></script>
	<script src="global_assets/js/plugins/tables/datatables/extensions/buttons.min.js"></script>
	<script src="assets/js/app.js"></script>
    <script src="global_assets/js/demo_pages/navbar_multiple_sticky.js"></script>
    <script src="global_assets/js/demo_pages/datatables_extension_buttons_html5.js"></script>
</head>

<body>
<?php 
$malzemesor = $db -> prepare ("SELECT * FROM ob_stok WHERE stok_id=:urun");
$malzemesor -> execute(array(
	'urun' => $_GET['stok']
));
$malzemecek = $malzemesor -> fetch(PDO::FETCH_ASSOC);
?>
	<div class="page-content pt-10">
		<div class="content-wrapper">
			<div class="content">
				<div class="card">
					<div class="card-header bg-light header-elements-inline">
						<h5 class="card-title"><i class="icon-list"></i> Malzeme Stok Hareketi</h5>
						<div class="header-elements">
							<div class="list-icons">
		                		<button type="button" onclick="yazdir()" class="btn btn-info">
                                    <b class="icon-printer"></b> Yazdır
                                </button>
		                	</div>
	                	</div>
					</div>
					<div class="card-body">
						<div class="aralik"><b>Barkod :</b> <?php echo $malzemecek['stok_barkod'] ?></div>
						<div class="aralik"><b>Malzeme :</b> <?php echo $malzemecek['stok_adi'] ?></div>
						<div class="aralik"><b>Stok :</b> <?php echo $malzemecek['stok_kalan'] ?></div>
						<table class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>Tarih</th>
									<th>Fatura No</th>
									<th>Fatura Türü</th>
									<th>G/Ç</th>
									<th>Miktar</th>
									<th>Birim Fiyat</th>
								</tr>
							</thead>
							<tbody>
								<?php 
								$stokhareketsor = $db -> prepare ("SELECT * FROM ob_stok_hareket WHERE m_hareket_mal=:urun");
								$stokhareketsor -> execute(array(
									'urun' => $malzemecek['stok_id']
								));
								while ($stokhareketcek = $stokhareketsor -> fetch(PDO::FETCH_ASSOC)) {
								?>
								<tr>
									<td>
										<?php
                                        $kaynak = substr($stokhareketcek["m_hareket_tarih"], 0, 10);
                                        $tarih = new DateTime($kaynak);
                                        echo $tarih->format('d-m-Y');
                                        ?>
									</td>
									<td><?php echo $stokhareketcek['m_hareket_fat_no'] ?></td>
									<td>
										<?php 
										$faturasor = $db -> prepare ("SELECT * FROM ob_fatura WHERE fatura_id=:fatura");
										$faturasor -> execute(array(
											'fatura' => $stokhareketcek['m_hareket_fatura_id']
										));
										$faturacek = $faturasor -> fetch(PDO::FETCH_ASSOC);
										
										$tursor = $db -> prepare ("SELECT * FROM ob_fatura_turu WHERE fat_tur_id=:faturaturu");
										$tursor -> execute(array(
											'faturaturu' => $faturacek['fatura_turu']
										));
										$turcek = $tursor -> fetch(PDO::FETCH_ASSOC);

										echo $turcek['fat_tur_adi'];
										?>
									</td>
									<td>
										<?php if ($stokhareketcek['m_hareket_giris_cikis'] == 1) { ?>
										<span class="badge badge-success">Çıkış</span>
										<?php } else if ($stokhareketcek['m_hareket_giris_cikis'] == 2) { ?>
										<span class="badge badge-primary">Giriş</span>
										<?php } ?>
									</td>
									<td><?php echo $stokhareketcek['m_hareket_miktar'] ?></td>
									<td>
										<?php
										$sayi1 = $stokhareketcek['m_hareket_fiyat'];
										$sayi2 = $stokhareketcek['m_hareket_kdv_oran'];
										$kdvbul = ($sayi1 * $sayi2) / 100;
										$toplamayap = $sayi1 + $kdvbul;
										
										echo number_format($toplamayap, 2, ',', '.');;
										?>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<div class="bosluk"></div>
		</div>
	</div>
	<script type="text/javascript">
		//print
		function yazdir() {
		    window.print();
		}
	</script>
</body>
</html>
